import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, concatenate_objects, create_dataframe, access_dataframe_loc

atp_tennis = read_csv_file('atp_tennis.csv')

# Calculate head-to-head win rates
h2h_win_rates = calculate_head_to_head_win_rate(atp_tennis)

# Initialize an empty DataFrame for storing the results
updated_odds_df = create_dataframe(data=[], columns=['Match ID', 'Original Odd_1', 'Original Odd_2', 'Updated Odd_1', 'Updated Odd_2'])

# Loop through the affected matches
for match_id in federer_match_ids:
    # Update the odds for the match
    updated_odd_1, updated_odd_2 = update_odds(match_id, 0.7, 0.3, atp_tennis, h2h_win_rates)

    # Append the results to the DataFrame
    original_odd_1 = access_dataframe_loc(atp_tennis, match_id, 'Odd_1')
    original_odd_2 = access_dataframe_loc(atp_tennis, match_id, 'Odd_2')
    updated_odds_df = concatenate_objects(updated_odds_df, create_dataframe(data={'Match ID': [match_id], 'Original Odd_1': [original_odd_1], 'Original Odd_2': [original_odd_2], 'Updated Odd_1': [updated_odd_1], 'Updated Odd_2': [updated_odd_2]}), reset_index_flag=True)

print(updated_odds_df)
pickle.dump(updated_odds_df,open("./ref_result/updated_odds_df.pkl","wb"))  